/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.client.entity.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.common.entity.vehicle.Boat;
import com.mysticsbiomes.common.entity.vehicle.ChestBoat;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoatRenderer
extends net.minecraft.client.renderer.entity.BoatRenderer {
    private final Map<Boat.Type, Pair<ResourceLocation, BoatModel>> boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)MysticsBiomes.modLoc(BoatRenderer.getTextureLocation(model, hasChest)), (Object)this.createBoatModel(context, (Boat.Type)((Object)model), hasChest))));

    public BoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context, false);
    }

    @Nonnull
    public Pair<ResourceLocation, BoatModel> getModelWithLocation(@Nonnull net.minecraft.world.entity.vehicle.Boat boat) {
        if (boat instanceof ChestBoat) {
            return this.boatResources.get((Object)((ChestBoat)boat).getModel());
        }
        return this.boatResources.get((Object)((Boat)boat).getModel());
    }

    private static String getTextureLocation(Boat.Type type, boolean hasChest) {
        return hasChest ? "textures/entity/boats/chest/" + type.getName() + ".png" : "textures/entity/boats/" + type.getName() + ".png";
    }

    private static ModelLayerLocation createLocation(String name) {
        return new ModelLayerLocation(MysticsBiomes.modLoc(name), "main");
    }

    public static ModelLayerLocation createBoatModelName(Boat.Type type) {
        return BoatRenderer.createLocation("boat/" + type.getName());
    }

    public static ModelLayerLocation createChestBoatModelName(Boat.Type type) {
        return BoatRenderer.createLocation("chest_boat/" + type.getName());
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, Boat.Type type, boolean hasChest) {
        ModelLayerLocation location = hasChest ? BoatRenderer.createChestBoatModelName(type) : BoatRenderer.createBoatModelName(type);
        return new BoatModel(context.m_174023_(location), hasChest);
    }
}

